import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Console extends JFrame implements ActionListener{
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
    JLabel question;			//题目
    JLabel labelA, labelB, labelC, labelD, labelE;	//显示5个待选答案
    JLabel results;			//正确答案
    JTextField youranswer;	//文本框
    JButton assure;			//确认提交答案按钮
    private JLabel accuracy;			//正确率
    private JLabel A,B,C,D,E;			//5个选择
    private JLabel askforanswer;		//请求答案
    private JLabel score; 				//当前分数

    private int times;   		//已答题目
    private int singles;   		//已答单选
    private int multis;    		//已答多选
    private int corrects;  		//正确题目
    private int ansnum;
    private String answer; 		//正确答案
    private String style = "英译中";   
    private int scores = 0;  	//分数
    boolean ismulti = false; 	//是否为多选
    private boolean running; 	//是否在运行

    private Console() {
        this.setTitle("百词斩山寨版");	//标题
        this.setLayout(null);		//无布局
        this.setBounds(50, 50, 720, 480);	//设置位置
        this.setResizable(false);		//不能调整大小
        this.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);	//关闭按钮
        //-
        running = true;
        singles = 0;
        multis = 0;
        times = singles + multis;
        corrects = 0;
        //-问题及准确率设置
        question = new JLabel();
        question.setBounds(50, 0, 300, 80);
        question.setFont(new Font("alias",Font.BOLD, 26));
        accuracy = new JLabel("accuracy: 0/0", JLabel.CENTER);
        accuracy.setBounds(520, 20, 150, 50);
        accuracy.setFont(new Font("alias",Font.BOLD, 18));
        //-正确答案及分数显示
        results = new JLabel();
        results.setBounds(400, 340, 300, 40);
        results.setFont(new Font("alias",Font.BOLD, 18));
        score =new JLabel("分数："+0);
        score.setBounds(100, 340, 300, 40);
        score.setFont(new Font("alias",Font.BOLD, 18));
        //-输入框设置
        askforanswer = new JLabel("输入答案");
        askforanswer.setBounds(240, 400, 80, 40);
        askforanswer.setFont(new Font("alias",Font.BOLD, 18));
        youranswer = new JTextField();
        youranswer.setBounds(320, 400, 60, 40);
        youranswer.setFont(new Font("alias",Font.BOLD, 18));
        assure = new JButton("确定");
        assure.addActionListener(this);
        assure.setFont(new Font("alias",Font.BOLD, 18));
        assure.setBounds(380, 400, 80, 40);
        //-5个按钮
        A = new JLabel("A");
        A.setFont(new Font("alias",Font.BOLD, 20));
        labelA = new JLabel();
        A.setBounds(50, 100, 25, 25);
        labelA.setBounds(100, 100, 240, 25);
        labelA.setFont(new Font("alias",Font.BOLD, 20));
        labelA.setOpaque(true);
        B = new JLabel("B");
        B.setFont(new Font("alias",Font.BOLD, 20));
        labelB = new JLabel();
        B.setBounds(350, 100, 25, 25);
        labelB.setBounds(400, 100, 240, 25);
        labelB.setFont(new Font("alias",Font.BOLD, 20));
        labelB.setOpaque(true);
        C = new JLabel("C");
        C.setFont(new Font("alias",Font.BOLD, 20));
        labelC = new JLabel();
        C.setBounds(50, 150, 25, 25);
        labelC.setBounds(100, 150, 240, 25);
        labelC.setFont(new Font("alias",Font.BOLD, 20));
        labelC.setOpaque(true);
        D = new JLabel("D");
        D.setFont(new Font("alias",Font.BOLD, 20));
        labelD = new JLabel();
        D.setBounds(350, 150, 25, 25);
        labelD.setBounds(400, 150, 240, 25);
        labelD.setFont(new Font("alias",Font.BOLD, 20));
        labelD.setOpaque(true);
        E = new JLabel("E");
        E.setFont(new Font("alias",Font.BOLD, 20));
        labelE = new JLabel();
        E.setBounds(50, 200, 25, 25);
        labelE.setBounds(100, 200, 240, 25);
        labelE.setFont(new Font("alias",Font.BOLD, 20));
        labelE.setOpaque(true);
        //-添加到Frame
        this.add(accuracy);		//正确率
        this.add(question);		//题目
        this.add(A);
        this.add(labelA);
        this.add(B);
        this.add(labelB);
        this.add(C);
        this.add(labelC);
        this.add(D);
        this.add(labelD);
        this.add(E);
        this.add(labelE);
        this.add(results);		//输出正确答案
        this.add(score);		//得分
        this.add(askforanswer);	//提示
        this.add(youranswer);	//输入文本框
        this.add(assure);		//确认提交
        setVisible(true);
        //-
        Object [] options = {"英译汉","汉译英"};
        int response = JOptionPane.showOptionDialog(this, "选择类型", "模式选择",
        		JOptionPane.DEFAULT_OPTION, JOptionPane.QUESTION_MESSAGE, null, options, options[0]);
        if(response==0) {
            style="英译中";
        }
        else if(response==1) {
            style="中译英";
        }
    }

    void setAnswer(String answer) {
        this.answer = answer;
    }
    void setAccuracy(){
        accuracy.setText("Accuracy: "+corrects+"/"+ times);
    }
    private void setScores() {
        score.setText("得分："+scores);
    }
    private void setResults() {
        results.setText("正确答案：" + answer);
    }
    void addTimes(){
        times++;
    }
    void addMulti(){
        multis++;
    }
    void addSingle(){
        singles++;
    }
    int getTimes() {	//返回已答题目
        return times;
    }
    int getSingleTimes() {	//返回已答单选
        return singles;
    }
    int getMultiTimes() {	//返回已答多选
        return multis;
    }
    String getStyle() {	//返回模式
        return style;
    }
    private boolean check(String ans) {		//检查答案
        return answer.contains(ans);
    }
    private int getAnsNum() {	//正确答案个数
    	return ansnum;
    }
    public void setAnsNum(int n) {
    	ansnum = n;
    }
    void setColor(){
        labelA.setBackground(null);
        labelB.setBackground(null);
        labelC.setBackground(null);
        labelD.setBackground(null);
        labelE.setBackground(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String ans;			//用户正确答案
        JLabel tempans;		//对应label
        if(e.getSource()==assure) {
            String texts = youranswer.getText();	//获取用户答案
            int correct = 0;
      
            if((ismulti&&texts.length()>=2)||(!ismulti&&texts.length()==1)) {	//先判断答案数目           	
                for (int i = 0; i < texts.length(); i++) {
                    if (texts.charAt(i) == 'A') {
                        ans = labelA.getText();
                        tempans = labelA;
                    } else if (texts.charAt(i) == 'B') {
                        ans = labelB.getText();
                        tempans = labelB;
                    } else if (texts.charAt(i) == 'C') {
                        ans = labelC.getText();
                        tempans = labelC;
                    } else if (texts.charAt(i) == 'D') {
                        ans = labelD.getText();
                        tempans = labelD;
                    } else if (texts.charAt(i) == 'E') {
                        ans = labelE.getText();
                        tempans = labelE;
                    }else{
                        break;
                    }
                    assert ans != null;
                    if (check(ans)) {
                        assert tempans != null;
                        tempans.setBackground(new Color(0, 255, 25));  			//设置正确答案为绿色
                        if ( (i+1==getAnsNum())&&(i+1==texts.length()) ) {	    //答案正确设置，只有个数正确才可能为正确
                            int flag = 1;
                            for(int j = 0; j < texts.length(); j++)		//重复选项不得分
                            	for(int k = 0; k < texts.length(); k++)
                            		if((k!=j)&&(texts.charAt(j)==texts.charAt(k)))
                            			flag = 0;
                            if(flag==1)
                            	correct = 1;
                        }
                    } else {
                        assert tempans != null;
                        tempans.setBackground(new Color(255, 72, 72)); //设置正确答案为红色                        
                        correct = 0;	 //答案错误直接跳出循环
                        break;
                    }
                }
            }          
            if(correct==1) {
                corrects++;
                if(ismulti){
                    scores+=10;
                }else{
                    scores+=5;
                }
            }
        }
        assure.setEnabled(false);
        setAccuracy();
        setScores();
        setResults();
    }
    
    public static void main(String[] args)
    {
        try{
            UIManager.setLookAndFeel( UIManager.getSystemLookAndFeelClassName() );
        }catch( Exception e ){
            e.printStackTrace();
        }
        Console test = new Console();
        GiveWord giveword = new GiveWord(test);
        while(true){
            if(test.running){
                Thread thread = new Thread(giveword);
                thread.start();
                break;
            }
        }
    }
}
