import java.io.*;
import java.util.*;

class WordsForSingleChoice {
    private final ArrayList<String> english = new ArrayList<String>();		//记录英文
    private final ArrayList<String> chinese = new ArrayList<String>();		//记录中文
    WordsForSingleChoice(String path) {			//以路径作为参数
        BufferedReader bufferedreader = null;
        try {
            bufferedreader = new BufferedReader(new InputStreamReader(new FileInputStream(path),"gbk"));
            while(true) {
                String oneline = bufferedreader.readLine();
                if(oneline==null) break;        
                String regex = "[\\s]+";  		//分割
                String [] words = oneline.split(regex);
                if(words.length < 2) continue;
                english.add(words[0]);
                chinese.add(words[1]);
            }
        } catch(Exception e){
            e.printStackTrace();
        }
        finally {
            try{
                bufferedreader.close();
            }catch(Exception e){
                e.printStackTrace();
            }
        }
    }
    private int getRandom() {
        int size = english.size();
        return (int)(Math.random()*size);
    }
    HashMap<String, String> getChoices()
    {
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        HashMap<String, String> selections = new HashMap<String, String>();
        for (int i = 0; i < 5 ; i++) {
            int index = getRandom();
            while(indexs.contains(index)) {
                index = getRandom();
            }
            indexs.add(index);
            selections.put(english.get(index), chinese.get(index));
        }
        return selections;
    }
}

